/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.gui.Focus;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.util.ErrorUtil;

public class FocusFactory
implements IFocusFactory {
    private final RegisteredIngredients registeredIngredients;

    public FocusFactory(RegisteredIngredients registeredIngredients) {
        this.registeredIngredients = registeredIngredients;
    }

    @Override
    public <V> IFocus<V> createFocus(IFocus.Mode mode, V ingredient) {
        ErrorUtil.checkNotNull(mode, "mode");
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        IIngredientType<V> ingredientType = this.registeredIngredients.getIngredientType(ingredient);
        return Focus.createFromApi(this.registeredIngredients, mode.toRole(), ingredientType, ingredient);
    }

    @Override
    public <V> IFocus<V> createFocus(RecipeIngredientRole role, IIngredientType<V> ingredientType, V ingredient) {
        ErrorUtil.checkNotNull(role, "role");
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        return Focus.createFromApi(this.registeredIngredients, role, ingredientType, ingredient);
    }
}

